
/*
 * xsetup.c - setup to display xab information
 * 		
 */

#include <stdio.h>
/*
 * Include files required for all Toolkit programs
 */
#include <X11/Intrinsic.h>	/* Intrinsics Definitions */
#include <X11/StringDefs.h>	/* Standard Name-String definitions */

/*
 * Public include file for widgets we actually use in this file.
 */
#ifdef X11R3
#include <X11/Command.h>		/* Athena Command Widget */
#else /* R4 or later */
#include <X11/Xaw/SmeBSB.h>             /* Athena bitmap for X11R4 */        
#include <X11/Xaw/Form.h>	        /* Athena Form Widget */
#include <X11/Xaw/Box.h>		/* Athena Box Widget */
#include <X11/Xaw/Command.h>		/* Athena Command Widget */
#include <X11/Xaw/Label.h>		/* Athena Label Widget */
#include <X11/Xaw/Scrollbar.h>		/* Athena Label Widget */
#endif /* X11R3 */


/*
 * Bitmap include files 
 */

#include "go.xbm"		/* go button icon */
#include "stop.xbm"		/* stop button icon */
#include "fwdstep.xbm"	/* fwdstep button icon */
#include "monitor.xbm"
#include "snd.xbm"
#include "sndd.xbm"
#include "rcv.xbm"
#include "rcvd.xbm"
#include "bar.xbm"
#include "bard.xbm"
#include "probe.xbm"
#include "put.xbm"
#include "get.xbm"
#include "clock.xbm"

/*
 *	Local includes
 */

#include "both.h"
#include "ab.h"
#include "mlist.h"
#include "xabmon.h"
#include "bstates.h"
#include "xsizes.h"

/*	Extern Globals */

extern XtIntervalId ioTimer;
extern int ioTimerActive;
extern int mypid;
extern printUps();
extern ups *ups_head;
extern int get_file_input();
extern FILE *abin;


/*	Globals */

int delayMs = 0;

Widget clockLabel;
Pixmap goPixmap, stopPixmap, fwdstepPixmap,
	monitorPixmap, clockPixmap;

Pixmap sndPixmap, snddPixmap, rcvPixmap, rcvdPixmap;
Pixmap barPixmap, bardPixmap, probePixmap, putPixmap, getPixmap;


XtAppContext app_context;
static XtWorkProcId id;
int buttonState = STOPPED;
XtInputId getFileId;
int getFileActive = 0;


/*	ab_probe
 *	call pvm probe to see if there is a message to handle
 */
XtWorkProc ab_probe(id)
int *id;
{

	/* if there is a message to handle */
	/*
	if (probe(-1) != -1)
		ab_handle();
	*/
	return(False);
		
}

/*
 * pause_cb button callback function
 */
void pause_cb(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{ 
	static char paused = 0;

	if(paused) {
		/* take the pause off */
		paused = 0;
		/* turn message checking on */
		/*
		id = XtAppAddWorkProc(app_context, ab_probe, &id);
		*/
		}
	else {
		/* set the pause on */
		paused = 1;
		/* turn message checking off */
		/*
		XtRemoveWorkProc(id);
		*/
		}

}

/*
 * dump_cb button callback function
 */
void dump_cb(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{ 
	printUps(ups_head);
}

/*
 * quit_cb button callback function
 */
void quit_cb(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{ 
	/*  XXX probably want to make sure the ps list is deleted */
	exit(0); 
}

/*	stop_cb button callback function
*
*	stop processing any file input
*/

void stop_cb(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{

	/* if we aren't already stopped */
	if (buttonState != STOPPED) {
		buttonState = STOPPED;
		if (getFileActive) {
			XtRemoveInput(getFileId);
			getFileActive = 0;
			}
		/* if the delay is set then the timer is too */
		/* better remove the timer */
		/* could check value of timer */
		if (ioTimerActive) {
			XtRemoveTimeOut(ioTimer);
			ioTimerActive = 0;
			}
		}
}


/*	fwdstep_cb button callback function
*
*	show just one event
*/

void 
fwdstep_cb(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{

	/* if we aren't already stopped */
	if (buttonState == STOPPED) {
		/* start playing */
		buttonState = FWDSTEP;
		getFileId = XtAppAddInput(app_context, fileno(abin), XtInputReadMask, get_file_input, (XtPointer)NULL);
		getFileActive = 1;
		}
}

/*	wakeUpFrom a timeout and put the file io routine back on line 
*
*/

void 
wakeUpInput()
{
/*
	note that get_file_input will call XtAppAddInput, we don't
	want to do it here 
*/
	/* the timer is no longer active */
	ioTimerActive = 0;
	/* if we are still playing */
	if (buttonState == PLAYING) {
		/* add the file io */
		getFileId = XtAppAddInput(app_context, fileno(abin), XtInputReadMask,
			get_file_input, (XtPointer)NULL);
		getFileActive = 1;

		}
}

/*	go_cb button callback function
*
*	start processing any file input
*/

void 
go_cb(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{

	/* if we aren't already playing */
	if (buttonState != PLAYING) {
		/* start playing */
		buttonState = PLAYING;
		getFileId = XtAppAddInput(app_context, fileno(abin), XtInputReadMask,
			get_file_input, (XtPointer)NULL);
		getFileActive = 1;
		}
}

/* speedJump_cb
*	set the speed of the playback 
*/
void speedJump_cb(sb, client_data, per)
Widget sb;
XtPointer client_data;
XtPointer per; /* float */
{
	/* the delay in milliseconds (0 - 2000ms)  */

	delayMs = (int)( *(float*)per * 2000.0 );
}


/* speedScroll_cb
*	set the speed of the playback 
*/
void speedScroll_cb(sb, client_data, pos)
Widget sb;
XtPointer client_data;
XtPointer pos; /* int */
{
printf("pos %d\n", pos);
}

/* allow others to see this */
Widget machBox;

xsetup(argcp, argv)
int *argcp;
char **argv;
{
	Widget topLevel, topForm, buttonBox, dump, pause, quit, stopButton, 
		goButton, fwdstepButton, speedScroll;

	Window xRootW;
	Display *xDisp;
	int xScrn;
	Arg arg[10];
	int n;

	topLevel = XtVaAppInitialize(
		&app_context,
		"XAb",		/* Application class */
		NULL, 0,	/* command line optino list */
		argcp,	/* number of args */
		argv,	/* command line */
		NULL,
		NULL);

	topForm = XtCreateManagedWidget(
		"topForm",				/* arbitrary widget name */
		formWidgetClass,	/* widget class from Command.h */
		topLevel,			/* parent widget*/
		NULL,				/* argument list */
		0					/* arg list size */
		);

	/* box to contain all of the buttons */
	n = 0;
	/*
	XtSetArg(arg[n], XtNorientation, XtorientHorizontal); n++;
	*/
	XtSetArg(arg[n], XtNwidth, 200); n++;
	buttonBox = XtCreateManagedWidget(
		"buttonBox",			/* arbitrary widget name */
		boxWidgetClass,	
		topForm,			/* parent widget*/
		arg,			/* argument list */
		n				/* arg list size */
		);

	/* box to contain all of the machines */
	n = 0;
	XtSetArg(arg[n], XtNfromVert, buttonBox); n++;
	XtSetArg(arg[n], XtNheight, 200); n++;
	XtSetArg(arg[n], XtNwidth, MACHBOXWIDTH); n++;
	machBox = XtCreateManagedWidget(
		"machBox",			/* arbitrary widget name */
		boxWidgetClass,	
		topForm,			/* parent widget*/
		arg,				/* argument list */
		n					/* arg list size */
		);

	n = 0;
	XtSetArg(arg[n], XtNleft, XtChainLeft); n++;
	XtSetArg(arg[n], XtNright,  XtChainLeft); n++;
	XtSetArg(arg[n], XtNtop,    XtChainTop); n++;
	XtSetArg(arg[n], XtNbottom, XtChainTop); n++;
	/* the stop button allows the user to stop the display of events */
	stopButton = XtCreateManagedWidget(
		"stopButton",		/* arbitrary widget name */
		commandWidgetClass,	/* widget class from Command.h */
		buttonBox,	/* parent widget*/
		arg,		/* argument list */
		n		/* arg list size */
		);

	XtAddCallback(stopButton, XtNcallback, stop_cb, 0);

	/* use the same arg, but add the fromHoriz */
	XtSetArg(arg[n], XtNfromHoriz, stopButton); n++;
	/* the go button starts the display of events */
	goButton = XtCreateManagedWidget(
		"goButton",		/* arbitrary widget name */
		commandWidgetClass,	/* widget class from Command.h */
		buttonBox,	/* parent widget*/
		arg,		/* argument list */
		n		/* arg list size */
		);

	XtAddCallback(goButton, XtNcallback, go_cb, 0);

	XtSetArg(arg[n-1], XtNfromHoriz, goButton); 

	/* the fwdstepbutton displays one event */
	fwdstepButton = XtCreateManagedWidget(
		"fwdstepButton",		/* arbitrary widget name */
		commandWidgetClass,	/* widget class from Command.h */
		buttonBox,	/* parent widget*/
		arg,		/* argument list */
		n		/* arg list size */
		);

	XtAddCallback(fwdstepButton, XtNcallback, fwdstep_cb, 0);


	--n;
	XtSetArg(arg[n], XtNheight, 20);  n++;
	XtSetArg(arg[n], XtNfromVert, stopButton); n++;

	/* the clockLabel displays the time */
	clockLabel = XtCreateManagedWidget(
		"clockLabel",		/* arbitrary widget name */
		labelWidgetClass,	/* widget class from Command.h */
		buttonBox,	/* parent widget*/
		arg,		/* argument list */
		n		/* arg list size */
		);

	XtSetArg(arg[n-1], XtNfromHoriz, fwdstepButton); 
	/* the quit button quits the application */
	quit = XtCreateManagedWidget(
		"quit",		/* arbitrary widget name */
		commandWidgetClass,	/* widget class from Command.h */
		buttonBox,	/* parent widget*/
		arg,		/* argument list */
		n		/* arg list size */
		);

	XtAddCallback(quit, XtNcallback, quit_cb, 0);


	n = 0;
	XtSetArg(arg[n], XtNfromVert, clockLabel); 
	XtSetArg(arg[n], XtNorientation, XtorientHorizontal);  n++;
	XtSetArg(arg[n], XtNthickness, 20);  n++;
	XtSetArg(arg[n], XtNlength, 100);  n++;
	XtSetArg(arg[n], XtNminimumThumb, 16);  n++;

	/* the speedScroll controls the speed of the playback */
	speedScroll = XtCreateManagedWidget(
		"speedScroll",		/* arbitrary widget name */
		scrollbarWidgetClass,	/* widget class from Command.h */
		buttonBox,	/* parent widget*/
		arg,		/* argument list */
		n		/* arg list size */
		);

	/*
	Dealing with the scoll is a pain, deal with it later
	XtAddCallback(speedScroll, XtNscrollProc, speedScroll_cb, 0);
	*/
	XtAddCallback(speedScroll, XtNjumpProc, speedJump_cb, 0);


    xDisp = XtDisplay(topLevel);
    xScrn = DefaultScreen(xDisp);
    xRootW = RootWindow(xDisp, xScrn);

	stopPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn), 
		stop_bits, stop_height, stop_width, 1, 0, 1);

	goPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn), 
		go_bits, go_height, go_width, 1, 0, 1);

	fwdstepPixmap =XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn), 
		fwdstep_bits, fwdstep_height, fwdstep_width, 1, 0, 1);

    monitorPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		monitor_bits, monitor_height, monitor_width, 1, 0, 1);

    sndPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		snd_bits, snd_height, snd_width, 1, 0, 1);

    snddPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		sndd_bits, sndd_height, sndd_width, 1, 0, 1);

    rcvPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		rcv_bits, rcv_height, rcv_width, 1, 0, 1);

    rcvdPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		rcvd_bits, rcvd_height, rcvd_width, 1, 0, 1);

    barPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		bar_bits, bar_height, bar_width, 1, 0, 1);

    bardPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		bard_bits, bard_height, bard_width, 1, 0, 1);

    probePixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		probe_bits, probe_height, probe_width, 1, 0, 1);

    putPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		put_bits, put_height, put_width, 1, 0, 1);

    getPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		get_bits, get_height, get_width, 1, 0, 1);

    clockPixmap = XCreatePixmapFromBitmapData(xDisp, RootWindow(xDisp, xScrn),
		clock_bits, clock_height, clock_width, 1, 0, 1);

    XtVaSetValues(clockLabel,
        XtNlabel, "  hh:mm:ss:musecs",
		XtNjustify, XtJustifyLeft,
        XtNwidth, 150,
        XtNleftBitmap, clockPixmap,
		XtNheight, 20,
        NULL);

	XtVaSetValues(stopButton,
		XtNbitmap, stopPixmap,
		NULL);

	XtVaSetValues(goButton,
		XtNbitmap, goPixmap,
		NULL);

	XtVaSetValues(fwdstepButton,
		XtNbitmap, fwdstepPixmap,
		NULL);

	/*
	 *  Create windows for widgets and map them.
	 */
	XtRealizeWidget(topLevel);
}
